package coreservlets.filters;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Oglny filtr modyfikujcy, ktry buforuje dane wynikowe, po czym
 *  metod doModification zmienia cig danych wynikowych przed ich
 *  wysaniem do klienta. Jest to klasa abstrakcyjna, dlatego
 *  <I>trzeba</I> pokry metod doModification w klasie potomnej.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public abstract class ModificationFilter implements Filter {
  protected FilterConfig config;
  private HttpServletRequest request;
  private HttpServletResponse response;

  public void doFilter(ServletRequest req,
                       ServletResponse resp,
                       FilterChain chain)
      throws ServletException, IOException {
    request = (HttpServletRequest)req;
    response = (HttpServletResponse)resp;
    StringWrapper responseWrapper = new StringWrapper(response);
    // Wywoanie zasobu i umieszczenie danych wynikowych
    // w obiekcie przechowujcym.
    chain.doFilter(request, responseWrapper);
    // Przeksztacenie kompletu danych wynikowych
    // w jeden duy cig znakw.
    String modifiedResponse =
      doModification(responseWrapper.toString());
    // Wysanie zmodyfikowanej odpowiedzi do klienta.
    PrintWriter out = response.getWriter();
    out.write(modifiedResponse);
  }

  /** Klasy dziedziczce po ModificationFilter musz
   *  pokrywa t metod.
   */
  public abstract String doModification(String origResponse)
  	throws IOException;


  /** Zapisanie obiektu dania na wypadek, gdyby
   *  musiaa z niego skorzysta klasa potomna.
   */
  public HttpServletRequest getRequest() {
    return(request);
  }

  /** Zapisanie obiektu odpowiedzi na wypadek, gdyby
   *  musiaa z niego skorzysta klasa potomna.
   */
  public HttpServletResponse getResponse() {
    return(response);
  }
  
  public void init(FilterConfig config) {
  	// Zapisanie obiektu FilterConfig do pniejszego uycia przez klas potomn.
    this.config = config;
  }

  public void destroy() {}
}
